<?php
session_start();

if (!isset($_SESSION['logged_in']) || !$_SESSION['logged_in']) {
    header('Location: index.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CREATE PANEL</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@10/dist/sweetalert2.min.css">
    
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            /* Background Serasi */
            background: linear-gradient(rgba(0, 0, 0, 0.6), rgba(0, 0, 0, 0.8)), url('https://i.ibb.co.com/wF8tS32F/IMG-20260120-WA0191.jpg') no-repeat center center fixed;
            background-size: cover;
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            color: #fff;
        }

        /* Navbar Keren */
        .navbar-custom {
            position: fixed;
            top: 0;
            width: 100%;
            background: rgba(0, 0, 0, 0.5);
            backdrop-filter: blur(10px);
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            padding: 15px 0;
            z-index: 1000;
            text-align: center;
        }

        .navbar-brand {
            font-size: 24px;
            font-weight: 700;
            color: #fff !important;
            text-transform: uppercase;
            letter-spacing: 2px;
            text-shadow: 0 0 10px rgba(56, 239, 125, 0.5);
        }
        
        .navbar-brand span {
            color: #38ef7d;
        }

        /* Card Glassmorphism */
        .glass-card {
            width: 100%;
            max-width: 450px;
            padding: 40px;
            background: rgba(255, 255, 255, 0.05);
            backdrop-filter: blur(15px);
            -webkit-backdrop-filter: blur(15px);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 20px;
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.5);
            text-align: center;
            position: relative;
            z-index: 10;
        }

        .card-title {
            color: #fff;
            font-size: 22px;
            font-weight: 600;
            margin-bottom: 30px;
            text-transform: uppercase;
            letter-spacing: 1px;
        }

        /* Input Styling */
        .form-group {
            position: relative;
            margin-bottom: 25px;
        }

        .form-control {
            background-color: rgba(0, 0, 0, 0.3);
            color: #fff;
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: 30px;
            padding: 25px 20px;
            font-size: 16px;
            text-align: center;
            transition: all 0.3s ease;
        }

        .form-control:focus {
            background-color: rgba(0, 0, 0, 0.5);
            border-color: #38ef7d;
            box-shadow: 0 0 15px rgba(56, 239, 125, 0.2);
            color: #fff;
        }
        
        .form-control::placeholder {
            color: #aaa;
        }

        /* Tombol Gradient */
        .btn-custom {
           background: linear-gradient(45deg, #11998e, #38ef7d);
           border: none;
           color: white;
           font-weight: 600;
           width: 100%;
           padding: 12px;
           font-size: 16px;
           border-radius: 30px;
           text-transform: uppercase;
           letter-spacing: 1px;
           transition: all 0.3s ease;
           box-shadow: 0 4px 15px rgba(56, 239, 125, 0.4);
           margin-top: 10px;
       }

        .btn-custom:hover {
           transform: translateY(-3px);
           box-shadow: 0 8px 25px rgba(56, 239, 125, 0.6);
           color: #fff;
       }

       .icon-wrapper {
           font-size: 40px;
           color: #38ef7d;
           margin-bottom: 20px;
       }
    </style>
</head>
<body>
    
    <audio autoplay loop>
        <source src="audio/1.mp3" type="audio/mp3">
    </audio>

    <nav class="navbar-custom">
        <a class="navbar-brand" href="#">MARGA <span>EAGLEBEST</span></a>
    </nav>

    <div class="glass-card">
        <div class="icon-wrapper">
            <i class="fas fa-cogs"></i>
        </div>
        <h2 class="card-title">Buat Panel Result</h2>
        
        <form method="post" action="panel.php">
            <div class="form-group">
                <input type="text" name="WEB" id="WEB" class="form-control" placeholder="Masukkan Nama Panel..." required autocomplete="off">
            </div>
            <button type="submit" class="btn-custom">
                <i class="fas fa-magic mr-2"></i> Create Panel
            </button>
        </form>
    </div>
   
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
    
    <script>
       function showWelcomeNotification() {
            Swal.fire({
                title: 'Haloo Nyeet !!',
                text: 'Buat Panel Di Pake Jangan Buat Doang',
                icon: 'info',
                confirmButtonText: 'SIAP',
                background: '#1a1a1a', // Dark theme alert
                customClass: {
                    title: 'text-white',
                    content: 'text-white'
                }
            });
        }

        document.addEventListener('DOMContentLoaded', function() {
            showWelcomeNotification();
        });
   </script>
</body>
</html>
